/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.crate;

import dev.toma.gunsrpg.resource.crate.ILootContentProvider;
import dev.toma.gunsrpg.resource.crate.LootConfigurationCategory;
import dev.toma.gunsrpg.resource.crate.LootEntry;
import dev.toma.gunsrpg.resource.crate.SlotConfiguration;
import dev.toma.gunsrpg.util.math.WeightedRandom;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public class LootConfig {
    public static final LootConfig EMPTY = new Empty();
    private final WeightedRandom<SlotConfiguration> slotConfigs;
    private final WeightedRandom<LootConfigurationCategory> categories;
    private final Map<LootConfigurationCategory, WeightedRandom<LootEntry>> entriesByCategory;

    public LootConfig(SlotConfiguration[] slots, LootConfigurationCategory[] categories, Map<LootConfigurationCategory, List<LootEntry>> entriesByCategory) {
        this.slotConfigs = new WeightedRandom<SlotConfiguration>(SlotConfiguration::getWeight, slots);
        this.categories = new WeightedRandom<LootConfigurationCategory>(LootConfigurationCategory::getWeight, categories);
        this.entriesByCategory = entriesByCategory.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::mapValues));
    }

    public ILootContentProvider getRandomContent() {
        int size = this.slotConfigs.getRandom().getCount();
        LootConfigurationCategory category = this.categories.getRandom();
        ItemStack[] items = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            items[i] = this.getByCategory(category);
        }
        return () -> items;
    }

    public ItemStack getByCategory(LootConfigurationCategory category) {
        LootEntry entry = this.entriesByCategory.get(category).getRandom();
        return entry.produceItem();
    }

    private WeightedRandom<LootEntry> mapValues(Map.Entry<LootConfigurationCategory, List<LootEntry>> entry) {
        return new WeightedRandom<LootEntry>(LootEntry::getWeight, entry.getValue().toArray(new LootEntry[0]));
    }

    private static final class Empty
    extends LootConfig {
        private static final ILootContentProvider NO_CONTENT = () -> new ItemStack[0];

        private Empty() {
            super(new SlotConfiguration[0], new LootConfigurationCategory[0], Collections.emptyMap());
        }

        @Override
        public ILootContentProvider getRandomContent() {
            return NO_CONTENT;
        }
    }
}

